/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

//see http://linas.org/art-gallery/escape/escape.html for more info on normalizing the Mandelbrot escape

void main(void)
{
    float e=100.0;
	vec2 c = vec2(
        (gl_FragCoord.x-iResolution.x/2.0)/iResolution.y,
        (gl_FragCoord.y-iResolution.y/2.0)/iResolution.y);
    c*=2.5;
    int ic=0;
    vec2 tz;
    vec2 z=vec2(0.0);
    for(int i=0;i<32;i++){
        if(length(z)<e){
            tz=z;
            z.x=tz.x*tz.x-z.y*tz.y+c.x;
            z.y=2.0*tz.x*tz.y+c.y;
            ic++;
        }
    }
    float m=float(ic)-(log(log(length(z))))/log(2.0);
    gl_FragColor=vec4(abs(sin(m/5.0)));
}
